<?
///////////////////////////////////////////////////////////
// Channel List v1.0 by venox[xL]. (c) Kevin Stacey 2004 //
//             Edited by Fyre[xL] for Release            //
///////////////////////////////////////////////////////////
/* ------------------------------------------------------//
This script works directly with FyreChat 2.0.75 or later.//
It uploads a list of users in the channel, once every 60 //
seconds by default.                                      //
The file that is uploaded is channel_list.txt            //
Below are a set of variables that you need to edit to    //
match your site/server's settings.                       //
-------------------------------------------------------- */
///////////////////////////////////////////////////////////
//                                                       //
//        Please edit the variable values below          //
//                                                       //
///////////////////////////////////////////////////////////

// ----------------- Server Settings --------------------//
	// This is the server path to your log file
	$config['logfile'] = "/home/domain/public_html/weblog/channel_list.txt";

	// This is the url to your icon's directory, do not add a trailing slash
	$config['iconurl'] = "http://www.domain.com/weblog/icons";

// ----------------- Channel Settings --------------------//

	// Channel Name
	$config['channel'] = "Op FyreChat";

	// Battle.Net Server
	$config['server'] = "uswest.battle.net";

	// Channel Bot's Name
	$config['botname'] = "FyreChatUser";

	// How often the channel updates, in seconds (default 60)
	$config['seconds'] = "60";

// ----------------- Style Settings --------------------//

	// Table width, pixels or % Example: 450 or 100%
	$config['tablewidth'] = "451";

	// Table Border
	$config['border'] = "0";

	// Table cellspacing
	$config['cellspacing'] = "1";

	// Table cellpadding
	$config['cellpadding'] = "3";

	// Row 1 Background Color
	$config['row1bg'] = "#5A5A5A";

	// Row 1 Border Color
	$config['row1border'] = "#6F6F6F";

	// Row 1 Text Color
	$config['row1text'] = "#FFFFFF";

	// Row 1 Background Color
	$config['row2bg'] = "#000000";

	// Row 1 Border Color
	$config['row2border'] = "#6F6F6F";

	// Row 1 Text Color
	$config['row2text'] = "#FFFFFF";

	// Table Header Text Color
	$config['alttc'] = "#72B9F0";

///////////////////////////////////////////////////////////
//                                                       //
//             Do not edit below this line.              //
//                                                       //
///////////////////////////////////////////////////////////
extract($config);
?>

	<style>
	.row1 {
	   background: <?= $row1bg; ?>;
	   border: 1px solid <?= $row1border; ?>;
	   color: <?= $row1text; ?>;
	}

	.row2 {
	   background: <?= $row2bg; ?>;
	   border: 1px solid <?= $row2border; ?>;
	   color: <?= $row2text; ?>;
	}

	.tc {
		color: <?= $alttc; ?>;
	}
	</style>

<?
   // Open the channel_list.txt file, with supression
	$lines = @file($logfile);

   $numusers = count($lines);
?>

	<!-- Written by venox[xL] - Edited by Fyre[xL] on: Nov 5, 2004 -->
	<center>
	<table border="<?= $border; ?>" cellpadding="<?= $cellpadding; ?>" cellspacing="<?= $cellspacing; ?>" width="<?= $tablewidth; ?>">
	<tr>
	 <td colspan="3" align="center" class="row1"><h3>Channel: <?= $channel; ?> @ <?= $server; ?></h3></td>
	</tr>
	<tr>
	 <td class="row1" colspan="3" align="center"><span class="tc"><b>Total Users:</b> </span><?= $numusers; ?></td>
	</tr>
	<tr>
	 <td class="row1 tc" width="28"><b>Game</b></td>
	 <td class="row1 tc"><b>Username</b></td>
	 <td class="row1 tc" width="28"><b>Ping</b></td>
	</tr>
<?
    
   $gameclient = array("BLIZZ"      => "Blizzard Representative",
                       "SYSOP"      => "System Operator",
                       "OP"         => "Channel Operator",
                       "SPKR"       => "Speaker",
                       "GLASSES"    => "Glasses",
                       "SQUELCH"    => "Squelched",
                       "GFOFFICIAL" => "GF Official",
                       "GFPLAYER"   => "GF Player",
                       "CHAT"       => "Chat User",
                       "DRTL"       => "Diablo",
                       "STAR"       => "StarCraft",
                       "DSHR"       => "Diablo Shareware",
                       "SSHR"       => "StarCraft Shareware",
                       "SEXP"       => "StarCraft BroodWar",
                       "JSTR"       => "StarCraft Japan",
                       "D2DV"       => "Diablo II",
                       "W2BN"       => "WarCraft II",
                       "D2XP"       => "Diablo II Lord of Destruction",
                       "WAR3"       => "WarCraft III",
                       "W3XP"       => "WarCraft III Frozen Throne",
                      );

   // Loop through lines in the file
	foreach ($lines as $line_num => $line) {
		$icon_start = strPos($line, "[ICON]");
		$icon_end = strPos($line, "[/ICON]");
		$icon = trim(substr($line, $icon_start, ($icon_end - $icon_start)));
		$icon = str_replace("[ICON]", "", $icon);
		$icon = '<img src="' . $iconurl . '/' . $icon . '.jpg" alt="' . $gameclient[$icon] . '" title="' . $gameclient[$icon] . '">';

		$user_start = strPos($line, "[USER]");
		$user_end = strPos($line, "[/USER]");
		$luser = trim(substr($line, $user_start, ($user_end - $user_start)));
		$luser = str_replace("[USER]", "", $luser);

		$ping_start = strPos($line, "[PING]");
		$ping_end = strPos($line, "[/PING]");
		$ping = trim(substr($line, $ping_start, ($ping_end - $ping_start)));
		$ping = str_replace("[PING]", "", $ping);
		$realping = $ping . "ms";

		if($ping == 'PLUG') {
			$ping = 'PLUG';
			$realping = 'UDP Plug';
		}
		elseif($ping == 0) {
			$ping = '0';
		}
		elseif($ping == -1) {
			$ping = '1b';
		}
		elseif($ping < 200) {
			$ping = '1g';
		}
		elseif($ping < 300) {
			$ping = '2g';
		}
		elseif($ping < 400) {
			$ping = '3y';
		}
		elseif($ping < 500) {
			$ping = '4y';
		}
		elseif($ping < 600) {
			$ping = '5r';
		}
		else {
			$ping = '6r';
		}

		$ping = '<img src="' . $iconurl . '/' . $ping . '.jpg" alt="' . $ping . '" title="' . $realping . '">';

		?>
		<tr>
		 <td class="row2" align="center" width="28"><?= $icon; ?></td>
		 <td class="row2" width="<?= $tablewidth; ?>"><?= $luser; ?></td>
		 <td class="row2" align="left" width="28"><?= $ping; ?></td>
		</tr>
		<?
	}
	$html = implode('', file($logfile));
?>
<tr>
 <td colspan="3" align="center" class="row1"><span class="tc"><b>*Note:</b></span> Channel list is uploaded every <?= $seconds; ?> seconds from <?= $botname; ?></td>
</tr>
</table>
</center>
