#ifndef TELNETSERVERAPI_H
#define TELNETSERVERAPI_H

#pragma once

#define MAX_MSN_TELNET_STATUSBAR		45

typedef DWORD_PTR HTSSESSION;
typedef HTSSESSION * LPHTSSESSION;

// MSNClient

extern HINSTANCE LocateTelnetServer(void);
extern void DisconnectTelnetServer(void);
extern void WriteTelnetLine(HTSSESSION Session, DWORD Source, BYTE Color, const char* Format, ...);

// Max status bar length == 80 characters typically, but depends on client's window size

// MSNClient APIs

enum MSNListEnum {
	ForwardList,
	ReverseList,
	AllowList,
	BlockList
};

typedef BOOL (WINAPI * EnumMSNSessionsCallback)(LPCSTR Participants, DWORD SourceId, BOOL Active, LPARAM lParam);
typedef BOOL (WINAPI * EnumMSNSessionsProc)(EnumMSNSessionsCallback EnumCallback, LPARAM lParam);
typedef BOOL (WINAPI * GetSessionStatusBarProc)(HTSSESSION Session, DWORD SourceId, LPSTR Text);
typedef BOOL (WINAPI * DisplaySessionParticipantsProc)(HTSSESSION Session, DWORD SourceId);
typedef BOOL (WINAPI * SendMSNMessageProc)(HTSSESSION Session, DWORD SourceId, LPCSTR Text);
typedef BOOL (WINAPI * CheckMSNCommandProc)(HTSSESSION Session, DWORD SourceId, LPCSTR Command);
typedef BOOL (WINAPI * InviteMSNUserProc)(HTSSESSION Session, DWORD SourceId, LPCSTR Passport);
typedef BOOL (WINAPI * CreateMSNConversationProc)(HTSSESSION Session, LPCSTR Passport,
												  LPDWORD SourceId);
typedef BOOL (WINAPI * CloseMSNConversationProc)(HTSSESSION Session, DWORD SourceId);
typedef BOOL (WINAPI * AddListUserProc)(HTSSESSION Session, MSNListEnum ListId, LPCSTR Passport);
typedef BOOL (WINAPI * RemoveListUserProc)(HTSSESSION Session, MSNListEnum ListId, LPCSTR Passport);
typedef BOOL (WINAPI * EnumMSNParticipantsCallback)(LPCSTR Passport, LPCSTR FriendlyName,
													LPARAM lParam);
typedef BOOL (WINAPI * EnumMSNParticipantsProc)(EnumMSNParticipantsCallback EnumCallback,
												DWORD SourceId, LPARAM lParam);

// TelnetServer APIs

// a source is a data source -- such as bot profile, or MSN conversation

typedef BOOL (WINAPI * WriteMSNTitleProc)(HTSSESSION Session, DWORD SourceId, LPCSTR Text);
typedef BOOL (WINAPI * WriteSessionLineProc)(HTSSESSION Session, LPCSTR SourceName, LPCSTR Text);
typedef LPCSTR (WINAPI * TranslateColorProc)(HTSSESSION Session, BYTE ColorCode);
typedef BOOL (WINAPI * PrepareStringProc)(LPSTR String);
typedef DWORD (WINAPI * GetSessionSourceCountProc)(HTSSESSION Session);
typedef BOOL (WINAPI * CheckPrivilegesProc)(HTSSESSION Session, LPDWORD Privileges);
typedef BOOL (WINAPI * GetActiveSessionProc)(LPHTSSESSION Session);

// "Shared" APIs

typedef BOOL (WINAPI * AttachSessionProc)(HTSSESSION Session, DWORD SourceId);
typedef BOOL (WINAPI * DetachSessionProc)(HTSSESSION Session, DWORD SourceId);

struct TelnetServerInformation {
	DWORD dwSize; // Version requested by the source plugin
	DWORD dwSupportedSize; // Highest version supported by TelnetServer.bcpx

	EnumMSNSessionsProc MSNEnumMSNSessions;

	GetSessionStatusBarProc MSNGetSessionStatusBar;
	DisplaySessionParticipantsProc MSNDisplaySessionParticipants;

	SendMSNMessageProc MSNSendMSNMessage;
	CheckMSNCommandProc MSNCheckMSNCommand;

	InviteMSNUserProc MSNInviteMSNUser;
	CreateMSNConversationProc MSNCreateMSNConversation;
	CloseMSNConversationProc MSNCloseMSNConversation;

	AddListUserProc MSNAddListUser;
	RemoveListUserProc MSNRemoveListUser;

	AttachSessionProc MSNAttachSession;
	DetachSessionProc MSNDetachSession;

	EnumMSNParticipantsProc MSNEnumMSNParticipants;



	WriteMSNTitleProc TSWriteMSNTitle;
	WriteSessionLineProc TSWriteSessionLine;
	TranslateColorProc TSTranslateColor;
	PrepareStringProc TSPrepareString;
	AttachSessionProc TSAttachSession;
	DetachSessionProc TSDetachSession;
	GetSessionSourceCountProc TSGetSessionSourceCount;
	CheckPrivilegesProc TSCheckPrivileges;
	GetActiveSessionProc TSGetActiveSession;
};

typedef TelnetServerInformation TelnetServerInformationCurrent;

#endif
