#ifndef PLUGINMENU_H
#define PLUGINMEHU_H

// PluginMenu Copyright (C) 2003 Skywing.

#pragma once

// Constants

#define PLUGIN_MENU_NAME				"&Plugins"

// Types

typedef DWORD (WINAPI * PluginMenuProc)(LPARAM lParam);

// Functions

/*
 *	BOOL WINAPI AddPluginMenuIteme(HMENU hMainMenu, LPCSTR lpszText, LPUINT lpuMenuId)
 *
 *	Summary:
 *
 *	This functions adds a new menu item to the Plugins menu.
 *
 *	Parameters:
 *
 *	hMainMenu:		Handle to the window's main menu bar.
 *	lpszText:		String to associate with the new menu item.
 *	lpuMenuId:		The command identifier of the new menu item, if it is successfully added.
 *
 *	Return values:
 *
 *	If the function succeeds, it returns TRUE.  A return value of FALSE indicates failure.
 *
 *	Remarks:
 *
 *	If the function succeeds, you must call the DrawMenuBar function to update the menu.
 *	If the Plugins menu does not exist, the function will create it.
 */

extern BOOL WINAPI AddPluginMenuItem(HMENU hMainMenu, LPCSTR lpszText, LPUINT lpuMenuId);

/*
 *	BOOL WINAPI RemovePluginMenuItem(HMENU hMainMenu, UINT uMenuId)
 *
 *	Summary:
 *
 *	This functions removes an existing item from the Plugins menu.
 *
 *	Parameters:
 *
 *	hMainMenu:	Handle to the window's main menu.
 *	uMenuId:	The command identifier of the menu item to remove.  This value must be acquired by
 *				a call to AddPluginMenuItem.
 *
 *	Return values:
 *
 *	If the function succeeds, it returns TRUE.  A return value of FALSE indicates failure.
 *
 *	Remarks:
 *
 *	If you create submenus using the new menuitem, then you must destroy remove them before calling
 *	this function and reset the menu's identifier.  To do this, you must access the menuitem by it's
 *	position.  You can find the menuitem's position by using the FindMenuByString function.
 *	If the function succeeds, you must call the DrawMenuBar function to update the menu.
 *	If the Plugins menu has no more menus, the function will destroy it.
 */

extern BOOL WINAPI RemovePluginMenuItem(HMENU hMainMenu, UINT uMenuId);

/*
 *	BOOL WINAPI RemovePluginMenuItemByPositon(HMENU hMainMenu, UINT uMenuId)
 *
 *	Summary:
 *
 *	This functions removes an existing item from the Plugins menu.
 *
 *	Parameters:
 *
 *	hMainMenu:	Handle to the window's main menu.
 *	uMenuId:	The position of the menu item to remove.  The menuitem identified by this value must
 *				be acquired by a call to AddPluginMenuItem.
 *
 *	Return values:
 *
 *	If the function succeeds, it returns TRUE.  A return value of FALSE indicates failure.
 *
 *	Remarks:
 *
 *	If you create submenus using the new menuitem, then you must destroy remove them before calling
 *	this function and reset the menu's identifier.  To do this, you must access the menuitem by it's
 *	position.  You can find the menuitem's position by using the FindMenuByString function.
 *	If the function succeeds, you must call the DrawMenuBar function to update the menu.
 *	If the Plugins menu has no more menus, the function will destroy it.
 */

extern BOOL WINAPI RemovePluginMenuItemByPositon(HMENU hMainMenu, UINT uMenuPos);

/*
 *	UINT WINAPI GetNextPluginMenuId(HMENU hMainMenu, UINT nRequired)
 *
 *	Summary:
 *
 *	This function returns the first unused command id usable with the Plugins menu.
 *
 *	Parameters:
 *
 *	hMainMenu:	Handle to the window's main menu.
 *	nRequired:	Number of contiguous menu IDs required.
 *
 *	Return values:
 *
 *	If the function succeeds, it returns the first free command id usable with the Plugins menu.  A 
 *	return value of zero indicates failure.
 *
 *	Remarks:
 *
 *	This function does not reserve a menu id; a menu id is only guaranteed to be unused until the menu
 *	is modified.
 *	This function begins searching for unused menus at command id 20000.  Earlier command values are
 *	reserved for use by the parent application.
 */

#ifndef __cplusplus
extern UINT WINAPI GetNextPluginMenuId(HMENU hMainMenu, UINT nRequired);
#else
extern UINT WINAPI GetNextPluginMenuId(HMENU hMainMenu, UINT nRequired = 1);
#endif

/*
 *	HMENU WINAPI LocatePluginMenu(HMENU hMainMenu)
 *
 *	Summary:
 *
 *	This function returns a handle to the Plugins menu.
 *
 *	Parameters:
 *
 *	hMainMenu:	Handle to the window's main menu.
 *
 *	Return values:
 *
 *	If the function succeeds, it returns a handle the Plugins menu.  A return value of NULL indicates
 *	failure.
 *
 *	Remarks:
 *
 *	This function does not create the Plugins menu if it does not exist.
 */

extern HMENU WINAPI LocatePluginMenu(HMENU hMainMenu);

/*
 *	UINT WINAPI ToggleMenuItem(HMENU hMain, UINT uIDItem)
 *
 *	Summary:
 *
 *	This function toggles a menu's checked state.
 *
 *	Parameters:
 *
 *	hMainMenu:	Handle to the menu
 *	uIDItem:	Command identifier of the menu item to toggle
 *
 *	Return values:
 *
 *	The function returns the previous state of the menu item.
 */

extern UINT WINAPI ToggleMenuItem(HMENU hMenu, UINT uIDItem);

/*
 *	UINT WINAPI FindMenuByString(HMENU hMenu, LPCSTR lpszString)
 *
 *	Summary:
 *
 *	This function returns the position of the first menu item with the given string.
 *
 *	Parameters:
 *
 *	hMenu:		Handle to the menu to search.
 *
 *	Return values:
 *
 *	If the function succeeds, it returns the position of the menu item.  A return value of -1
 *	indicates failure.
 *
 *	Remarks:
 *
 *	The search is case sensitive.
 */

extern UINT WINAPI FindMenuByString(HMENU hMenu, LPCSTR lpszString);

#endif
