// PluginMenu Copyright (C) 2003 Skywing.

#include <windows.h>

#include "PluginMenu.h"

HMENU FindPluginMenu(HMENU hMainMenu)
{
	UINT MenuItems = GetMenuItemCount(hMainMenu);

	for(UINT i = 0; i < MenuItems; i++) {
		int MenuStringSize;
		LPSTR MenuString = new CHAR[MenuStringSize = GetMenuString(hMainMenu, i, 0, 0, MF_BYPOSITION)+1];
		if(GetMenuString(hMainMenu, i, MenuString, MenuStringSize, MF_BYPOSITION)
			&& !strcmp(MenuString, PLUGIN_MENU_NAME)) {
			delete [] MenuString;
			return GetSubMenu(hMainMenu, i);
		}

		delete [] MenuString;
	}

	// Menu not found, create it

	HMENU PopupMenu = CreateMenu();

	AppendMenu(hMainMenu, MF_STRING | MF_POPUP, (UINT_PTR)PopupMenu, PLUGIN_MENU_NAME);

	return PopupMenu;
}

void RemovePluginMenu(HMENU hMainMenu)
{
	int MenuItems = GetMenuItemCount(hMainMenu);

	for(int i = 0; i < MenuItems; i++) {
		int MenuStringSize;
		LPSTR MenuString = new CHAR[MenuStringSize = GetMenuString(hMainMenu, i, 0, 0, MF_BYPOSITION)+1];

		if(GetMenuString(hMainMenu, i, MenuString, MenuStringSize, MF_BYPOSITION)
			&& !strcmp(MenuString, PLUGIN_MENU_NAME)) {
			delete [] MenuString;

			DeleteMenu(hMainMenu, i, MF_BYPOSITION);
			return;
		}

		delete [] MenuString;
	}
}

bool CheckContiguosMenuId(HMENU Menu, UINT& MenuId, UINT Required)
{
	UINT EndRange = MenuId+Required;

	do {
		if(GetMenuState(Menu, MenuId+Required, MF_BYCOMMAND) != -1) {
			MenuId = EndRange; // No need to rescan the same area multiple times
			return false;
		}
	} while(--Required);

	return true;
}

BOOL WINAPI AddPluginMenuItem(HMENU hMainMenu, LPCSTR lpszText, LPUINT lpuMenuId)
{
	if(!lpuMenuId)
		return FALSE;

	*lpuMenuId = GetNextPluginMenuId(hMainMenu);

	if(!*lpuMenuId)
		return FALSE;

	HMENU PluginMenu = FindPluginMenu(hMainMenu);
	AppendMenu(PluginMenu, MF_STRING, *lpuMenuId, lpszText);

	return TRUE;
}

BOOL WINAPI RemovePluginMenuItem(HMENU hMainMenu, UINT uMenuId)
{
	HMENU PluginMenu = FindPluginMenu(hMainMenu);
	BOOL Result = DeleteMenu(PluginMenu, uMenuId, MF_BYCOMMAND);

	if(!GetMenuItemCount(PluginMenu))
		RemovePluginMenu(hMainMenu);

	return Result;
}

BOOL WINAPI RemovePluginMenuItemByPosition(HMENU hMainMenu, UINT uMenuPos)
{
	HMENU PluginMenu = FindPluginMenu(hMainMenu);
	BOOL Result = DeleteMenu(PluginMenu, uMenuPos, MF_BYPOSITION);

	if(!GetMenuItemCount(PluginMenu))
		RemovePluginMenu(hMainMenu);

	return Result;
}

UINT WINAPI GetNextPluginMenuId(HMENU hMainMenu, UINT nRequired)
{
	UINT MenuId = 20000;

	do {
		while(GetMenuState(hMainMenu, MenuId, MF_BYCOMMAND) != -1)
			++MenuId;
	} while(!CheckContiguosMenuId(hMainMenu, MenuId, nRequired));

	return MenuId;
}


HMENU WINAPI LocatePluginMenu(HMENU hMainMenu)
{
	UINT MenuItems = GetMenuItemCount(hMainMenu);

	for(UINT i = 0; i < MenuItems; i++) {
		int MenuStringSize;
		LPSTR MenuString = new CHAR[MenuStringSize = GetMenuString(hMainMenu, i, 0, 0, MF_BYPOSITION)+1];
		if(GetMenuString(hMainMenu, i, MenuString, MenuStringSize, MF_BYPOSITION)
			&& !strcmp(MenuString, PLUGIN_MENU_NAME)) {
			delete [] MenuString;
			return GetSubMenu(hMainMenu, i);
		}

		delete [] MenuString;
	}

	return NULL;
}

UINT WINAPI ToggleMenuItem(HMENU hMenu, UINT uIDItem)
{
	UINT uOldState = GetMenuState(hMenu, uIDItem, MF_BYCOMMAND);

	if(uOldState & MF_CHECKED)
		CheckMenuItem(hMenu, uIDItem, MF_BYCOMMAND | MF_UNCHECKED);
	else
		CheckMenuItem(hMenu, uIDItem, MF_BYCOMMAND | MF_CHECKED);

	return uOldState;
}

UINT WINAPI FindMenuByString(HMENU hMenu, LPCSTR lpszString)
{
	UINT MenuItems = GetMenuItemCount(hMenu);

	for(UINT i = 0; i < MenuItems; i++) {
		int MenuStringSize;
		LPSTR MenuString = new CHAR[MenuStringSize = GetMenuString(hMenu, i, 0, 0, MF_BYPOSITION)+1];
		if(GetMenuString(hMenu, i, MenuString, MenuStringSize, MF_BYPOSITION)
			&& !strcmp(MenuString, lpszString)) {
			delete [] MenuString;
			return i;
		}

		delete [] MenuString;
	}

	return -1;
}