#ifndef _PLUGIN_H_INCLUDED
#define _PLUGIN_H_INCLUDED
#pragma once

#include "HookManager.h"

class Plugin : public HookManager
{
protected:
	// Message hook
#if MESSAGEHOOK_ENABLED
	BOOL MessageHook(PluginAPI::ConnectionInterface Connection,
		BYTE MessageId, LPCVOID MessageData, DWORD MessageSize);
#endif

	// Connection hook
#if CONNECTIONHOOK_ENABLED
	BOOL ConnectionHook(PluginAPI::ConnectionInterface Connection,
		PluginAPI::ConnectionState EventCode, DWORDLONG PlatformId);
#endif

	// Plugin timer
#if PLUGINTIMER_ENABLED
	DWORD PluginTimer(DWORD TimeDelay);
#endif

	// Command hook
#if COMMANDHOOK_ENABLED
	BOOL CommandHook(LPCSTR Message, LPCSTR SendingUser, BOOL FromTelnet);
#endif

	// Event hook
#if EVENTHOOK_ENABLED
	BOOL EventHook();
#endif

	// Enum channel callback
	BOOL EnumChannelHook(LPCSTR UniqueName, LPCSTR Statstring, DWORD Flags, DWORD Ping,
	 					 BOOL Invisible, DWORD AccountNumber, DWORD RegAuthority);

#if HIGHEST_REVISION >= 4
	// Enum filter callbacks and enum plugins callback
	BOOL EnumUserFiltersHook(LPCSTR Filter);
	BOOL EnumMessageFiltersHook(LPCSTR Filter);
	BOOL EnumLoadedPluginsHook(HINSTANCE PluginInst);
#endif

public:
	// Instead of constructor/destructor, use these:
	BOOL Initialize(); // Return FALSE to abort (if this returns FALSE, Terminate isn't called)
	void Terminate(); // Do any termination here
};

#endif // _PLUGIN_H_INCLUDED