#ifndef _HOOKMANAGER_H_INCLUDED
#define _HOOKMANAGER_H_INCLUDED
#pragma once

#include "BinaryChatAPIManager.h"

class HookManager
{
	friend BOOL WINAPI PluginMain(PluginAPI::PluginInformation* Information);
		// PluginMain may read/set the private/protected variables/proc addresses

	friend class BinaryChatAPIManager;
		// BinaryChatAPIManager may call protected virtual functions

private:
	// Message hook
#if MESSAGEHOOK_ENABLED
	static BOOL WINAPI MessageHook(DWORD ConnectionId, BYTE MessageId,
		LPCVOID MessageData, DWORD MessageSize, LPARAM lParam);
#endif

	// Connection hook
#if CONNECTIONHOOK_ENABLED
	static BOOL WINAPI ConnectionHook(DWORD ConnectionId, DWORD EventCode,
		DWORDLONG PlatformId, LPARAM lParam);
#endif

	// Plugin timer
#if PLUGINTIMER_ENABLED
	static DWORD WINAPI PluginTimer(DWORD TimeDelay, LPARAM lParam);
#endif

	// Command hook
#if COMMANDHOOK_ENABLED
	static BOOL WINAPI CommandHook(LPCSTR Message, LPCSTR SendingUser, BOOL FromTelnet, LPARAM lParam);
#endif

	// Event hook
#if EVENTHOOK_ENABLED
	static BOOL WINAPI EventHook(LPARAM lParam);
#endif

protected:
	HINSTANCE m_PluginInstance;

	// Message hook (virtual function)
#if MESSAGEHOOK_ENABLED
	virtual BOOL MessageHook(PluginAPI::ConnectionInterface Connection,
		BYTE MessageId, LPCVOID MessageData, DWORD MessageSize) = 0;
#endif

	// Connection hook (virtual function)
#if CONNECTIONHOOK_ENABLED
	virtual BOOL ConnectionHook(PluginAPI::ConnectionInterface Connection,
		PluginAPI::ConnectionState EventCode, DWORDLONG PlatformId) = 0;
#endif

	// Plugin timer (virtual function)
#if PLUGINTIMER_ENABLED
	virtual DWORD PluginTimer(DWORD TimeDelay) = 0;
#endif

	// Command hook (virtual function)
#if COMMANDHOOK_ENABLED
	virtual BOOL CommandHook(LPCSTR Message, LPCSTR SendingUser, BOOL FromTelnet) = 0;
#endif

	// Event hook (virtual function) + event handle
#if EVENTHOOK_ENABLED
	HANDLE m_Event;

	virtual BOOL EventHook() = 0;
#endif

	// Enum channel callback
	virtual BOOL EnumChannelHook(LPCSTR UniqueName, LPCSTR Statstring, DWORD Flags, DWORD Ping,
		BOOL Invisible, DWORD AccountNumber, DWORD RegAuthority) = 0;

#if HIGHEST_REVISION >= 4
	// Enum filter callbacks and enum plugins callback
	virtual BOOL EnumUserFiltersHook(LPCSTR Filter) = 0;
	virtual BOOL EnumMessageFiltersHook(LPCSTR Filter) = 0;
	virtual BOOL EnumLoadedPluginsHook(HINSTANCE PluginInst) = 0;
#endif
};

#endif // _HOOKMANAGER_H_INCLUDED