#include "HookManager.h"

// Message hook
#if MESSAGEHOOK_ENABLED
	// Callback
	BOOL WINAPI HookManager::MessageHook(DWORD ConnectionId, BYTE MessageId,
										 LPCVOID MessageData, DWORD MessageSize, LPARAM lParam)
	{
		return ((HookManager*)lParam)->MessageHook((PluginAPI::ConnectionInterface)ConnectionId,
			MessageId, MessageData, MessageSize);
	}
#endif

// Connection hook
#if CONNECTIONHOOK_ENABLED
	// Callback
	BOOL WINAPI HookManager::ConnectionHook(DWORD ConnectionId, DWORD EventCode,
											DWORDLONG PlatformId, LPARAM lParam)
	{
		return ((HookManager*)lParam)->ConnectionHook((PluginAPI::ConnectionInterface)ConnectionId,
			(PluginAPI::ConnectionState)EventCode, PlatformId);
	}
#endif

// Plugin timer
#if PLUGINTIMER_ENABLED
	// Callback
	DWORD WINAPI HookManager::PluginTimer(DWORD TimeDelay, LPARAM lParam)
	{
		return ((HookManager*)lParam)->PluginTimer(TimeDelay);
	}
#endif

// Command hook
#if COMMANDHOOK_ENABLED
	// Callback
	BOOL WINAPI HookManager::CommandHook(LPCSTR Message, LPCSTR SendingUser,
										  BOOL FromTelnet, LPARAM lParam)
	{
		return ((HookManager*)lParam)->CommandHook(Message, SendingUser, FromTelnet);
	}
#endif

// Event hook
#if EVENTHOOK_ENABLED
	// Callback
	BOOL WINAPI HookManager::EventHook(LPARAM lParam)
	{
		return ((HookManager*)lParam)->EventHook();
	}
#endif