#ifndef _BINARYCHATAPIMANAGER_H_INCLUDED
#define _BINARYCHATAPIMANAGER_H_INCLUDED
#pragma once

#include "BCPlugin.h"
#include "PluginSettings.h"

class BinaryChatAPIManager
{
	friend BOOL WINAPI PluginMain(PluginAPI::PluginInformation* Information);
		// PluginMain may set the private variables (proc addresses)

private:
	DWORD m_Revision; // Revision number

	// REVISION 1

	PluginAPI::ClearMessageProc						m_ClearMessage;
	PluginAPI::IsMessageSetProc						m_IsMessageSet;
	PluginAPI::SetMessageProc						m_SetMessage;
	PluginAPI::QueueMessageProc						m_QueueMessage;
	PluginAPI::QueueChatMessageProc					m_QueueChatMessage;
	PluginAPI::CloseConnectionProc					m_CloseConnection;
	PluginAPI::SendConnectionMessageProc			m_SendConnectionMessage;
	PluginAPI::QueryStateInformationProc			m_QueryStateInformation;
	PluginAPI::QueryChannelInformationProc			m_QueryChannelInformation;
	PluginAPI::SetOutputColorProc					m_SetOutputColor;
	PluginAPI::WriteOutputTimestampProc				m_WriteOutputTimestamp;
	PluginAPI::WriteOutputStringProc				m_WriteOutputString;

	static BOOL WINAPI EnumChannelHook(LPCSTR UniqueName, LPCSTR Statstring,
		DWORD Flags, DWORD Ping, BOOL Invisible,
		DWORD AccountNumber, DWORD RegAuthority, LPARAM lParam);

	// REVISION 2

#if HIGHEST_REVISION >= 2
	PluginAPI::ProcessBotCommandProc				m_ProcessBotCommand;
#endif

	// REVISION 3

#if HIGHEST_REVISION >= 3
	PluginAPI::GetRegistryPathProc					m_GetRegistryPath;
	PluginAPI::ResetAwayIdleProc					m_ResetAwayIdle;
	PluginAPI::IsServiceProc						m_IsService;
	PluginAPI::GetWindowProc						m_GetWindow;
	PluginAPI::GetMenuProc							m_GetMenu;
#endif

	// REVISION 4

#if HIGHEST_REVISION >= 4
	PluginAPI::IsUserFilteredProc					m_IsUserFiltered;
	PluginAPI::IsMessageFilteredProc				m_IsMessageFiltered;
	PluginAPI::EnumUserFiltersProc					m_EnumUserFilters;
	PluginAPI::EnumMessageFiltersProc				m_EnumMessageFilters;
	PluginAPI::AddUserFilterProc					m_AddUserFilter;
	PluginAPI::AddMessageFilterProc					m_AddMessageFilter;
	PluginAPI::RemoveUserFilterProc					m_RemoveUserFilter;
	PluginAPI::RemoveMessageFilterProc				m_RemoveMessageFilter;
	// PluginAPI::NotifyMsgProc						m_NotifyMsg; // Public because of ellipsis
	PluginAPI::EnumLoadedPluginsProc				m_EnumLoadedPlugins;

	static BOOL WINAPI EnumUserFiltersHook(LPCSTR Filter, LPARAM lParam);
	static BOOL WINAPI EnumMessageFiltersHook(LPCSTR Filter, LPARAM lParam);
	static BOOL WINAPI EnumLoadedPluginsHook(HINSTANCE PluginInst, LPARAM lParam);
#endif

	// BinaryChat Version API

#if BINARYCHATAPI_ENABLED
	BinaryChatAPI::GetBotVersionProc				m_GetBotVersion;
	BinaryChatAPI::GetBotVersionExProc				m_GetBotVersionEx;
	BinaryChatAPI::QueryConfigurationSettingProc	m_QueryConfigurationSetting;
#endif

public:
	DWORD Revision() { return m_Revision; }

	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 1
	//
	
	BOOL ClearMessage(BYTE MessageId)
		{ return m_ClearMessage(MessageId); }

	BOOL IsMessageSet(BYTE MessageId)
		{ return m_IsMessageSet(MessageId); }

	BOOL SetMessage(BYTE MessageId)
		{ return m_SetMessage(MessageId); }

	BOOL QueueMessage(BYTE MessageId, LPCVOID MessageData, DWORD MessageSize)
		{ return m_QueueMessage(MessageId, MessageData, MessageSize); }

	BOOL QueueChatMessage(LPSTR ChatMessage, BOOL FixD2Command)
		{ return m_QueueChatMessage(ChatMessage, FixD2Command); }

	BOOL CloseConnection(PluginAPI::ConnectionInterface Connection)
		{ return m_CloseConnection((DWORD)Connection); }

	BOOL SendConnectionMessage(PluginAPI::ConnectionInterface Connection,
							   BYTE MessageId, LPCVOID MessageData, DWORD MessageSize)
		{ return m_SendConnectionMessage((DWORD)Connection, MessageId, MessageData, MessageSize); }

	BOOL QueryStateInformation(PluginAPI::StateInformation* StateInfo)
		{ return m_QueryStateInformation(StateInfo); }

	BOOL QueryChannelInformation()
		{ return m_QueryChannelInformation(&BinaryChatAPIManager::EnumChannelHook, (LPARAM)&PluginInstance); }

	BOOL SetOutputColor(PluginAPI::OutputColor Color)
		{ return m_SetOutputColor(Color); }

	BOOL WriteOutputTimestamp()
		{ return m_WriteOutputTimestamp(); }

	BOOL WriteOutputString(LPCSTR String)
		{ return m_WriteOutputString(String); }

	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 2
	// (Make sure this revision is present before calling this, or it'll crash!)
	//

#if HIGHEST_REVISION >= 2
	BOOL ProcessBotCommand(LPCSTR Command)
		{ return m_ProcessBotCommand(Command); }
#endif

	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 3
	// (Make sure this revision is present before calling this, or it'll crash!)
	//

#if HIGHEST_REVISION >= 3
	LPCSTR GetRegistryPath()
		{ return m_GetRegistryPath(); }
	
	BOOL ResetAwayIdle()
		{ return m_ResetAwayIdle(); }

	BOOL IsService()
		{ return m_IsService(); }

	HWND GetWindow(PluginAPI::BinaryChatWindow WindowId)
		{ return m_GetWindow(WindowId); }

	HMENU GetMenu(PluginAPI::BinaryChatMenu MenuId)
		{ return m_GetMenu(MenuId); }
#endif

	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 4
	// (Make sure this revision is present before calling this, or it'll crash!)
	//

#if HIGHEST_REVISION >= 4
	BOOL IsUserFiltered(LPCSTR User)
		{ return m_IsUserFiltered(User); }

	BOOL IsMessageFiltered(LPCSTR Message)
		{ return m_IsMessageFiltered(Message); }

	BOOL EnumUserFilters()
		{ return m_EnumUserFilters(&BinaryChatAPIManager::EnumUserFiltersHook, (LPARAM)&PluginInstance); }

	BOOL EnumMessageFilters()
		{ return m_EnumMessageFilters(&BinaryChatAPIManager::EnumMessageFiltersHook, (LPARAM)&PluginInstance); }

	BOOL AddUserFilter(LPCSTR Filter, BOOL SaveFilters)
		{ return m_AddUserFilter(Filter, SaveFilters); }

	BOOL AddMessageFilter(LPCSTR Filter, BOOL SaveFilters)
		{ return m_AddMessageFilter(Filter, SaveFilters); }

	BOOL RemoveUserFilter(LPCSTR Filter, BOOL SaveFilters)
		{ return m_RemoveUserFilter(Filter, SaveFilters); }

	BOOL RemoveMessageFilter(LPCSTR Filter, BOOL SaveFilters)
		{ return m_RemoveMessageFilter(Filter, SaveFilters); }

	PluginAPI::NotifyMsgProc NotifyMsg; // Public because of ellipsis

	BOOL EnumLoadedPlugins()
		{ return m_EnumLoadedPlugins(&BinaryChatAPIManager::EnumLoadedPluginsHook, (LPARAM)&PluginInstance); }
#endif

	// BinaryChat Version functions
	// Return type for all of these is a "troolean":
	// TRUE on success, FALSE on failure, -1 indicating function not found
#if BINARYCHATAPI_ENABLED
	BOOL GetBotVersion(int* Version, char* BuildTime, char* BuildDate, char* AuthBuildName)
	{
		return m_GetBotVersion
			? m_GetBotVersion(Version, BuildTime, BuildDate, AuthBuildName)
			: -1;
	}

	BOOL GetBotVersionEx(int* Version, char* BuildTime, char* BuildDate,
						 char* AuthBuildName, int* BuildNumber)
	{
		return m_GetBotVersionEx
			? m_GetBotVersionEx(Version, BuildTime, BuildDate, AuthBuildName, BuildNumber, NULL)
			: -1;
	}

	BOOL QueryConfigurationSetting(BinaryChatAPI::ConfigurationSetting Setting,
								   char* Profile, void* Buffer, DWORD* BufferLength)
	{
		return m_QueryConfigurationSetting
			? m_QueryConfigurationSetting(Setting, Profile, Buffer, BufferLength)
			: -1;
	}
#endif
};

#endif // _BINARYCHATAPIMANAGER_H_INCLUDED