#ifndef _BCPLUGIN_H_INCLUDED
#define _BCPLUGIN_H_INCLUDED
#pragma once

#include <windows.h>

class BotNetConnectionState;

namespace BinaryChatAPI // Procs are exported from BinaryChat.exe
{
	enum ConfigurationSetting {
		Setup_Username			= 0,
		Setup_Password			= 1,
		Setup_LastPing			= 2,
		Setup_Master			= 3,
		Setup_Operator			= 4,
		Setup_IdleMessage		= 5,
		Setup_Homechannel		= 6,
		Setup_Countidle			= 7,
		Setup_Log				= 8,
		Setup_Timestamp			= 9,
		Setup_UserNotifications	= 10,
		Setup_BattleNetServer	= 11,
		Setup_CDkey				= 12,
		Setup_LOD_CDkey			= 13,
		Setup_CDkeyName			= 14,
		Setup_Spawn				= 15,
		Setup_Product			= 16,
		Setup_ShowEncryptErrors	= 17,
		Setup_TelnetPort		= 18,
		Setup_TelnetPassword	= 19,
		Setup_EnableRealm		= 20,
		Setup_RealmCharacter	= 21,
		Setup_CharacterClass	= 22,
		Setup_InteractiveRealm	= 23,
		Setup_CharacterFlags	= 24,
		Setup_PingSpoof			= 25,
		Setup_WindowOptions		= 26,
		Setup_ShowAdbanners		= 27,
		Setup_WindowSize		= 28,
		Setup_WindowXPos		= 29,
		Setup_WindowYPos		= 30,
		Setup_Blank_Character	= 31,
		Setup_BotNetServer		= 32,
		Setup_BotNetServer_Pass	= 33,
		Setup_BotNetDatabaseId	= 34,
		Setup_ShowBotNetCmds	= 35,
		Setup_ConnectBattleNet	= 36
	};

	typedef BOOL (WINAPI* GetBotVersionProc)(int* Version, char* BuildTime,
		char* BuildDate, char* AuthBuildName);

	typedef BOOL (WINAPI* GetBotVersionExProc)(int* Version, char* BuildTime,
		char* BuildDate, char* AuthBuildName, int* BuildNumber, void* Reserved);

	typedef BOOL (WINAPI* QueryConfigurationSettingProc)(ConfigurationSetting Setting,
		char* Profile, void* Buffer, DWORD* BufferLength); // BufferLength in/out
}

namespace PluginAPI
{
	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 1
	//

	enum ConnectionInterface {
		Connection_BNCS,
		Connection_MCP,
		Connection_GS,
		Connection_Count // Last interface index +1 = amount of interfaces
	};

	enum ConnectionState {
		Connection_Closed,
		Connection_Opened
	};

	enum OutputColor {
		White,
		Gray,
		Blue,
		Green,
		Red,
		Yellow,
		Purple,
		BlueGreen,
		MidBlue,
		DarkBlue,
		DarkGreen,
		DarkYellow,
		DarkRed,
		DarkPurple,
		LightBlue,
		NumColors // Last color index +1 = amount of colors
	};

	struct StateInformation {
		DWORD Size;

		char ChannelName[256];
		DWORD ChannelFlags;

		char UniqueName[256];
		char AccountName[256];
		char Statstring[256];

		ConnectionState State[Connection_Count];
	};

	// Prototypes of callback functions

	// Hooks:
	typedef BOOL (WINAPI* MessageHookProc)(DWORD ConnectionId, BYTE MessageId,
										   LPCVOID MessageData, DWORD MessageSize, LPARAM lParam);
	typedef BOOL (WINAPI* ConnectionHookProc)(DWORD ConnectionId, DWORD EventCode,
											  DWORDLONG PlatformId, LPARAM lParam);
	typedef DWORD (WINAPI* PluginTimerProc)(DWORD TimeDelay, LPARAM lParam);
	typedef BOOL (WINAPI* CommandHookProc)(LPCSTR Message, LPCSTR SendingUser,
										   BOOL FromTelnet, LPARAM lParam);
	typedef BOOL (WINAPI* EventHookProc)(LPARAM lParam);

	// Channel enum:
	typedef BOOL (WINAPI* EnumChannelProc)(LPCSTR UniqueName, LPCSTR Statstring,
										   DWORD Flags, DWORD Ping, BOOL Invisible,
										   DWORD AccountNumber, DWORD RegAuthority, LPARAM lParam);

	// Prototypes of BinaryChat API functions
	typedef BOOL (WINAPI* ClearMessageProc)(BYTE MessageId);
	typedef BOOL (WINAPI* IsMessageSetProc)(BYTE MessageId);
	typedef BOOL (WINAPI* SetMessageProc)(BYTE MessageId);
	typedef BOOL (WINAPI* QueueMessageProc)(BYTE MessageId, LPCVOID MessageData, DWORD MessageSize);
	typedef BOOL (WINAPI* QueueChatMessageProc)(LPSTR ChatMessage, BOOL FixD2Command);
	typedef BOOL (WINAPI* QueryStateInformationProc)(StateInformation* StateInfo);
	typedef BOOL (WINAPI* QueryChannelInformationProc)(EnumChannelProc Callback, LPARAM lParam);
	typedef BOOL (WINAPI* CloseConnectionProc)(DWORD ConnectionId);
	typedef BOOL (WINAPI* SendConnectionMessageProc)(DWORD ConnectionId, BYTE MessageId,
													 LPCVOID MessageData, DWORD MessageSize);
	typedef BOOL (WINAPI* SetOutputColorProc)(OutputColor Color);
	typedef BOOL (WINAPI* WriteOutputTimestampProc)(void);
	typedef BOOL (WINAPI* WriteOutputStringProc)(LPCSTR String);

	struct PluginInformation {
		DWORD Size;

		ClearMessageProc NetClearMessage;
		IsMessageSetProc NetIsMessageSet;
		SetMessageProc NetSetMessage;
		QueueMessageProc NetQueueMessage;
		QueueChatMessageProc NetQueueChatMessage;
		QueryStateInformationProc SysQueryStateInformation;
		QueryChannelInformationProc SysQueryChannelInformation;
		CloseConnectionProc NetCloseConnection;
		SendConnectionMessageProc NetSendConnectionMessage;
		SetOutputColorProc UISetColor;
		WriteOutputTimestampProc UIWriteTimestamp;
		WriteOutputStringProc UIWriteString;

		HINSTANCE BotNetClientInstance;
		BotNetConnectionState* BotNetConnection;

		MessageHookProc MessageHook;		// non-const
		LPARAM MessageHookParam;			// non-const

		ConnectionHookProc ConnectionHook;	// non-const
		LPARAM ConnectionHookParam;			// non-const

		PluginTimerProc PluginTimer;		// non-const
		LPARAM PluginTimerParam;			// non-const

		CommandHookProc CommandHook;		// non-const
		LPARAM CommandHookParam;			// non-const

		HINSTANCE PluginInstance;

		EventHookProc EventHook;			// non-const
		LPARAM EventHookParam;				// non-const
		HANDLE PluginEvent;
	};

	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 2
	//

	typedef BOOL (WINAPI * ProcessBotCommandProc)(LPCSTR lpszCommand);

	struct PluginInformation2 : public PluginInformation
	{
		ProcessBotCommandProc SysProcessBotCommand;
	};

	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 3
	//

	enum BinaryChatWindow {
		MainWindow,
		ChannelList,
		ChannelNameStatic,
		UserInput,
		ChatOutput,
		AccountManager,
		RealmManager,
		DownloadManager,
		NewsWindow,
		FiltersManager,
		ChannelsManager
	};

	enum BinaryChatMenu {
		MainWindowMenu,
		ChannelUserPopupMenu // NOTE: this is actually the first submenu, not the parent menu
	};
	
	typedef LPCSTR (WINAPI* GetRegistryPathProc)(void);
	typedef BOOL (WINAPI* ResetAwayIdleProc)(void);
	typedef HWND (WINAPI* GetWindowProc)(BinaryChatWindow WindowId);
	typedef BOOL (WINAPI* IsServiceProc)(void);
	typedef HMENU (WINAPI* GetMenuProc)(BinaryChatMenu MenuId);

	struct PluginInformation3 : public PluginInformation2
	{
		GetRegistryPathProc RegGetRegistryPath;
		ResetAwayIdleProc NetResetAwayIdle;
		GetWindowProc UIGetWindow;
		IsServiceProc SysIsService;
		GetMenuProc UIGetMenu;
	};

	//////////////////////////////////////////////////////////////////////////////
	//
	// REVISION 4
	//

	typedef BOOL (WINAPI* EnumFilterProc)(LPCSTR Filter, LPARAM lParam);
	typedef BOOL (WINAPI* EnumPluginsProc)(HINSTANCE PluginInst, LPARAM lParam);

	typedef BOOL (WINAPI* IsUserFilteredProc)(LPCSTR User);
	typedef BOOL (WINAPI* IsMessageFilteredProc)(LPCSTR Message);
	typedef BOOL (WINAPI* EnumUserFiltersProc)(EnumFilterProc Callback, LPARAM lParam);
	typedef BOOL (WINAPI* EnumMessageFiltersProc)(EnumFilterProc Callback, LPARAM lParam);
	typedef BOOL (WINAPI* AddUserFilterProc)(LPCSTR Filter, BOOL SaveFilters);
	typedef BOOL (WINAPI* AddMessageFilterProc)(LPCSTR Filter, BOOL SaveFilters);
	typedef BOOL (WINAPI* RemoveUserFilterProc)(LPCSTR Filter, BOOL SaveFilters);
	typedef BOOL (WINAPI* RemoveMessageFilterProc)(LPCSTR Filter, BOOL SaveFilters);
	typedef BOOL (WINAPIV* NotifyMsgProc)(OutputColor Color, LPCSTR User, LPCSTR MessageFormat, ...);
	typedef BOOL (WINAPI* EnumLoadedPluginsProc)(EnumPluginsProc Callback, LPARAM lParam);

	struct PluginInformation4 : public PluginInformation3 {
		IsUserFilteredProc FltIsUserFiltered;
		IsMessageFilteredProc FltIsMessageFiltered;
		EnumUserFiltersProc FltEnumUserFilters;
		EnumMessageFiltersProc FltEnumMessageFilters;
		AddUserFilterProc FltAddUserFilter;
		AddMessageFilterProc FltAddMessageFilter;
		RemoveUserFilterProc FltRemoveUserFilter;
		RemoveMessageFilterProc FltRemoveMessageFilter;
		NotifyMsgProc UINotifyMsg;
		EnumLoadedPluginsProc SysEnumLoadedPlugins;
	};
}

BOOL WINAPI PluginMain(PluginAPI::PluginInformation* Information);
	// Export as "SetInterfaceInformation"

#endif // _BCPLUGIN_H_INCLUDED