#ifndef BCP_H
#define BCP_H

// BCP.h - Copyright (C) 2003 Skywing
// Plugin revision 6 is NOT FINALIZED.  The information relating to revision 6 in
// this file is PRELIMINARY and LIKELY TO CHANGE.

// For the Encryption, PubKey, and DesKey classes, see Adron's Encryption Library.
// This can be found at http://www.adron.org/Encryption/
// These members should be set to zero if they are not supported for any reason.

// All BinaryChat plugins must export the function SetInterfaceInformation, which
// must conform to the PluginInitProc prototype.

// All extended (multibot-aware) BinaryChat plugins must export the function
// SetInterfaceInformationEx, which must conform to the PluginInitExProc prototype.

// All BinaryChat plugins can assume that they are both always called from only one
// thread, and that their caller runs an alertable message loop which properly
// calls IsDialogMessage for dialogs.

// Additionally, any program supporting the plugin interface should initialize the
// common controls, RichEdit 2.00, and Winsock 2.02.

#pragma once

#include <windows.h>
#include <time.h>

// BinaryChat Plugin API

#define NUM_INTERFACES 3

namespace PluginAPI {
	enum {
		Connection_BNCS = 0,
		Connection_MCP,
		Connection_GS
	};

	enum {
		Connection_Closed = 0,
		Connection_Opened,
	};

	enum {
		Main_Window = 0,
		Channel_List,
		Channel_Name,
		User_Input,
		Chat_Output,
		Account_Manager,
		Realm_Manager,
		Download_Manager,
		News_Window,
		Filters_Manager,
		Channels_Manager,
	};

	enum {
		Main_Window_Menu = 0,
		Channel_User_Popup_Menu, // NOTE: this is actually the first submenu, not the parent menu
		// v6
		Tray_Menu
	};

	// v5
	enum {
		Output_Normal,
		Output_Timestamp
	};

	enum {
		Plugin_Activate,
		Plugin_Deactivate
	};

	enum {
		PBCE_From_Telnet		=		0x00000001
	};

	enum {
		QCE_Fix_D2_Command		=		0x00000001,
		QCE_Process_Modifiers	=		0x00000002,
		QCE_Reset_Away_Idle		=		0x00000004
	};

	enum {
		Control_Start = 0,
		Control_Stop,
		Control_Hide,
		Control_Show,
		Control_Create_Profile,
		Control_Exit,
		Control_Load_Library,
		Control_Free_Library,
		Control_Get_Service_Status_Handle,
		Control_Get_Service_Status
	};

	enum {
		Tray_Notify_Window = 0
	};
};

// Color constants

namespace BotOutput {
	enum {				// R   , G   , B
		WHITE = 0,		// 0xff, 0xff, 0xff
		GRAY = 1,		// 0x7f, 0x7f, 0x7f
		BLUE = 2,		// 0x00, 0xff, 0xff
		GREEN = 3,		// 0x00, 0xff, 0x00
		RED = 4,		// 0xff, 0x00, 0x00
		YELLOW = 5,		// 0xff, 0xff, 0x00
		PURPLE = 6,		// 0xff, 0x00, 0xff
		BLUEGREEN = 7,		// 0x00, 0x7f, 0x7f
		MIDBLUE = 8,		// 0x00, 0x00, 0xff
		DARKBLUE = 9,		// 0x00, 0x00, 0x7f
		DARKGREEN = 10,		// 0x10, 0xaf, 0x10
		DARKYELLOW = 11,	// 0x7f, 0x7f, 0x00
		DARKRED = 12,		// 0x7f, 0x00, 0x00
		DARKPURPLE = 13,	// 0x7f, 0x00, 0x7f
		LIGHTBLUE = 14		// 0x00, 0x6f, 0xff
	};
};

struct PluginInformation;
typedef struct PluginInformation5 PluginInformationCurrent;
struct StateInformation;
class BotNetConnectionState;
struct PluginInformationEx;

typedef struct { int unused; } *HBINARYCHAT, **PHBINARYCHAT, **LPHBINARYCHAT;
typedef struct { int unused; } *HINTERFACELIST, **PHINTERFACELIST, **LPHINTERFACELIST;


// User functions
typedef BOOL (WINAPI * PluginInitProc)(PluginInformation * lpInterfaceInfo);
typedef BOOL (WINAPI * MessageHookProc)(DWORD dwConnectionId, BYTE MessageId,
										LPCVOID lpMessageData, DWORD nMessageSize,
										LPARAM lParam);
typedef BOOL (WINAPI * EnumChannelProc)(LPCSTR lpszUniqueName, LPCSTR lpszStatstring,
										DWORD dwFlags, DWORD dwPing, BOOL bInvisible,
										DWORD dwAccountNumber, DWORD dwRegAuthority,
										LPARAM lParam);
typedef BOOL (WINAPI * ConnectionHookProc)(DWORD dwConnectionId, DWORD dwEventCode,
										   DWORDLONG qwPlatformId, LPARAM lParam);
typedef DWORD (WINAPI * PluginTimerProc)(DWORD dwTimeDelay, LPARAM lParam);
typedef BOOL (WINAPI * CommandHookProc)(LPCSTR lpszMessage, LPCSTR lpszSendingUser,
										BOOL bFromTelnet, LPARAM lParam);
typedef BOOL (WINAPI * EventHookProc)(LPARAM lParam);
typedef BOOL (WINAPI * EnumFilterProc)(LPCSTR lpszFilter, LPARAM lParam);
typedef BOOL (WINAPI * EnumPluginsProc)(HINSTANCE hPlugin, LPARAM lParam);
// v5
typedef BOOL (WINAPI * PluginDestroyProc)(LPARAM lParam);
typedef BOOL (WINAPI * OutputHookProc)(DWORD dwReason, BYTE Color, LPCSTR lpszMessage, LPARAM lParam);
typedef VOID (WINAPI * DeferredProcedureCallProc)(LPARAM lParam);
// v6
typedef BOOL (WINAPI * MessageSendHookProc)(DWORD dwConnectionId, BYTE MessageId,
											LPVOID lpMessageData, DWORD nMessageSize,
											LPARAM lParam);
typedef BOOL (WINAPI * TextModifierSendHookProc)(DWORD dwConnectionId, LPCSTR lpszMessageText,
												 LPARAM lParam);
typedef BOOL (WINAPI * TextModifierReceiveHookProc)(DWORD dwConnectionId, LPSTR lpszMessageText,
													LPARAM lParam);

// Multibot support (bcpx) user functions
typedef BOOL (WINAPI * PluginInitExProc)(PluginInformationEx * lpInterfaceInfo);
typedef BOOL (WINAPI * PluginDestroyExProc)(LPARAM lParam);
typedef BOOL (WINAPI * PluginControlProc)(DWORD dwOperation, PluginInformation * lpInterfaceInfo,
										  HBINARYCHAT hBinaryChat, LPARAM lParam);
typedef BOOL (WINAPI * EnumInstancesProc)(HBINARYCHAT hBinaryChat, LPARAM lParam);
typedef BOOL (WINAPI * EnumProfilesProc)(LPCSTR lpszProfileName, LPARAM lParam);

// APIs
typedef BOOL (WINAPI * ClearMessageProc)(BYTE MessageId);
typedef BOOL (WINAPI * IsMessageSetProc)(BYTE MessageId);
typedef BOOL (WINAPI * SetMessageProc)(BYTE MessageId);
typedef BOOL (WINAPI * QueueMessageProc)(BYTE MessageId, LPCVOID lpMessageData,
										 DWORD nMessageSize);
typedef BOOL (WINAPI * QueueChatMessageProc)(LPSTR lpszChatMessage, BOOL bFixD2Command);
typedef BOOL (WINAPI * QueryStateInformationProc)(StateInformation * lpStateInfo);
typedef BOOL (WINAPI * QueryChannelInformationProc)(EnumChannelProc lpCallback,
													LPARAM lParam);
typedef BOOL (WINAPI * CloseConnectionProc)(DWORD dwConnectionId);
typedef BOOL (WINAPI * SendConnectionMessageProc)(DWORD dwConnectionId, BYTE MessageId,
												  LPCVOID lpMessageData, DWORD nMessageSize);
typedef BOOL (WINAPI * SetOutputColorProc)(BYTE ColorId);
typedef BOOL (WINAPI * WriteOutputTimestampProc)(void);
typedef BOOL (WINAPI * WriteOutputStringProc)(LPCSTR lpszString);
typedef BOOL (WINAPI * ProcessBotCommandProc)(LPCSTR lpszCommand);
typedef LPCSTR (WINAPI * GetRegistryPathProc)(void);
typedef BOOL (WINAPI * ResetAwayIdleProc)(void);
typedef HWND (WINAPI * GetWindowProc)(DWORD dwWindowId);
typedef BOOL (WINAPI * IsServiceProc)(void);
typedef HMENU (WINAPI * GetMenuProc)(DWORD dwMenuId);
typedef BOOL (WINAPI * IsUserFilteredProc)(LPCSTR lpszUser);
typedef BOOL (WINAPI * IsMessageFilteredProc)(LPCSTR lpszMessage);
typedef BOOL (WINAPI * EnumUserFiltersProc)(EnumFilterProc lpCallback, LPARAM lParam);
typedef BOOL (WINAPI * EnumMessageFiltersProc)(EnumFilterProc lpCallback, LPARAM lParam);
typedef BOOL (WINAPI * AddUserFilterProc)(LPCSTR lpszFilter, BOOL bSaveFilters);
typedef BOOL (WINAPI * AddMessageFilterProc)(LPCSTR lpszMessageFilter, BOOL bSaveFilters);
typedef BOOL (WINAPI * RemoveUserFilterProc)(LPCSTR lpszFilter, BOOL bSaveFilters);
typedef BOOL (WINAPI * RemoveMessageFilterProc)(LPCSTR lpszFilter, BOOL bSaveFilters);
typedef BOOL (WINAPIV * NotifyMsgProc)(BYTE bColor, LPCSTR lpszUser, LPCSTR lpszMessageFormat, ...);
typedef BOOL (WINAPI * EnumLoadedPluginsProc)(EnumPluginsProc lpCallback, LPARAM lParam);
// v5
typedef BOOL (WINAPI * ProcessBotCommandExProc)(LPCSTR lpszMessage, DWORD dwFlags,
												LPCSTR lpszRemoteUser);
typedef BOOL (WINAPI * QueueChatMessageExProc)(LPSTR lpszMessage, DWORD dwFlags);
typedef BOOL (WINAPI * QueueDPCProc)(DeferredProcedureCallProc DPC, LPARAM lParam);
// v6
// ...

// Multibot support (bcpx) APIs
typedef HBINARYCHAT (WINAPI * GetCurrentBinaryChatProc)(void);
typedef BOOL (WINAPI * SetCurrentBinaryChatProc)(HBINARYCHAT hBinaryChat);
typedef BOOL (WINAPI * EnumBinaryChatsProc)(EnumInstancesProc lpCallback, LPARAM lParam);
typedef BOOL (WINAPI * EnumBinaryChatProfilesProc)(EnumProfilesProc lpCallback, LPARAM lParam);
typedef LRESULT (WINAPI * ControlBinaryChatProc)(HBINARYCHAT hBinaryChat, DWORD dwControlCode, WPARAM wParam, LPARAM lParam);
typedef LPCSTR (WINAPI * GetBinaryChatProfileNameProc)(HBINARYCHAT hBinaryChat);
typedef LPCSTR (WINAPI * GetProfileRegistryPathProc)(void);
typedef HWND (WINAPI * ExGetWindowProc)(DWORD dwWindowId);
typedef HBINARYCHAT (WINAPI * PluginInformationToBinaryChatProc)(PluginInformationCurrent * lpPluginInformation, HINTERFACELIST hInterfaceList);
typedef PluginInformationCurrent * (WINAPI * BinaryChatToPluginInformationProc)(HBINARYCHAT hBinaryChat, HINTERFACELIST hInterfaceList);
typedef DWORD (WINAPI * GetBotIdProc)(HBINARYCHAT hBinaryChat);
typedef HBINARYCHAT (WINAPI * GetBinaryChatProc)(DWORD dwBotId);

struct PluginInformation {
	DWORD dwSize;

	ClearMessageProc PNetClearMessage;
	IsMessageSetProc PNetIsMessageSet;
	SetMessageProc PNetSetMessage;
	QueueMessageProc PNetQueueMessage;
	QueueChatMessageProc PNetQueueChatMessage;
	QueryStateInformationProc PSysQueryStateInformation;
	QueryChannelInformationProc PSysQueryChannelInformation;
	CloseConnectionProc PNetCloseConnection;
	SendConnectionMessageProc PNetSendConnectionMessage;
	SetOutputColorProc PUISetColor;
	WriteOutputTimestampProc PUIWriteTimestamp;
	WriteOutputStringProc PUIWriteString;

	HINSTANCE hBotNetClient;
	BotNetConnectionState * lpBotNetConnection;

	MessageHookProc MessageHook;							// non-const
	LPARAM MessageHookParam;								// non-const

	ConnectionHookProc ConnectionHook;						// non-const
	LPARAM ConnectionHookParam;								// non-const

	PluginTimerProc PluginTimer;							// non-const
	LPARAM PluginTimerParam;								// non-const

	CommandHookProc CommandHook;							// non-const
	LPARAM CommandHookParam;								// non-const

	HINSTANCE hPlugin;

	EventHookProc EventHook;								// non-const
	LPARAM EventHookParam;									// non-const
	HANDLE hPluginEvent;
};

struct PluginInformation2 : public PluginInformation {
	ProcessBotCommandProc PSysProcessBotCommand;
};

struct PluginInformation3 : public PluginInformation2 {
	GetRegistryPathProc PRegGetRegistryPath;
	ResetAwayIdleProc PNetResetAwayIdle;
	GetWindowProc PUIGetWindow;
	IsServiceProc PSysIsService;
	GetMenuProc PUIGetMenu;
};

struct PluginInformation4 : public PluginInformation3 { /* These all still need to be implemented in BinaryChatAPI.cpp! */
	IsUserFilteredProc PFltIsUserFiltered;
	IsMessageFilteredProc PFltIsMessageFiltered;
	EnumUserFiltersProc PFltEnumUserFilters;
	EnumMessageFiltersProc PFltEnumMessageFilters;
	AddUserFilterProc PFltAddUserFilter;
	AddMessageFilterProc PFltAddMessageFilter;
	RemoveUserFilterProc PFltRemoveUserFilter;
	RemoveMessageFilterProc PFltRemoveMessageFilter;
	NotifyMsgProc PUINotifyMsg;
	EnumLoadedPluginsProc PSysEnumLoadedPlugins;
};

struct PluginInformation5 : public PluginInformation4 {
	class Encryption* EncryptionInstance;
	class PubKey** RSATarget;
	class DesKey** DESTarget;

	ProcessBotCommandExProc PSysProcessBotCommandEx;
	QueueChatMessageExProc PNetQueueChatMessageEx;
	QueueDPCProc PSysQueueDPC;

	PluginDestroyProc PluginDestroy;						// non-const
	LPARAM PluginDestroyParam;								// non-const

	OutputHookProc OutputHook;								// non-const
	LPARAM OutputHookParam;									// non-const
};

// PRELIMINARY
struct PluginInformation6 : public PluginInformation5 {
	// ...

	MessageSendHookProc MessageSendHook;					// non-const
	LPARAM MessageSendHookParam;							// non-const

	TextModifierSendHookProc TextModifierSendHook;			// non-const
	LPARAM TextModifierSendHookParam;						// non-const

	TextModifierReceiveHookProc TextModifierReceiveHook;	// non-const
	LPARAM TextModifierReceiveHookParam;					// non-const

	// add BotNetXHook to replace old-style method of interacting with BotNetClient so we can unload
};

struct StateInformation {
	DWORD dwSize;

	char szChannelName[256];
	DWORD dwChannelFlags;

	char szUniqueName[256];
	char szAccountName[256];
	char szStatstring[256];

	DWORD dwConnectionState[NUM_INTERFACES];
};

struct PluginInformationEx {
	DWORD dwSize;
	DWORD dwPluginInformationSize;								// Highest PluginInformation supported

	GetCurrentBinaryChatProc PSysGetCurrentBinaryChat;
	SetCurrentBinaryChatProc PSysSetCurrentBinaryChat;
	EnumBinaryChatsProc PSysEnumBinaryChats;
	EnumBinaryChatProfilesProc PSysEnumBinaryChatProfiles;
	EnumLoadedPluginsProc PSysEnumExPlugins;
	ControlBinaryChatProc PSysControlBinaryChat;
	GetBinaryChatProfileNameProc PSysGetBinaryChatProfileName;
	GetProfileRegistryPathProc PRegGetProfileRegistryPath;
	ExGetWindowProc PUIGetExWindow;
	PluginInformationToBinaryChatProc PSysPluginInformationToBinaryChat;
	BinaryChatToPluginInformationProc PSysBinaryChatToPluginInformation;
	GetBotIdProc PSysGetBotId;
	GetBinaryChatProc PSysGetBinaryChat;

	PluginControlProc PluginControl;
	LPARAM PluginControlParam;

	PluginDestroyExProc PluginDestroyEx;
	LPARAM PluginDestroyExParam;

	HINSTANCE hPlugin;
	HINTERFACELIST hInterfaceList;								// Reserved for internal use
};

// End BinaryChat Plugin API

// BotNetClient API

// Virtual base-class for buffering classes
class VirtualBuffer {
public:
	virtual ~VirtualBuffer(void) { }
	virtual void insert(unsigned long data) = 0;
	virtual void insert(const char *data) = 0;
	virtual void insert(const void *data, int size) = 0;
	virtual void insert(const class LadderQuery &query) = 0;
	virtual void insert(const class LadderFind &find) = 0;
	virtual void insertbyte(unsigned char data) = 0;
	virtual void insertshort(unsigned short data) = 0;
	virtual unsigned long extract(void) = 0;
	virtual char *extract(char *databuf) = 0;
	virtual unsigned char extractbyte(void) = 0;
	virtual unsigned short extractshort(void) = 0;
	virtual void *extract(void *databuf, int size) = 0;
	virtual class LadderQueryResult &extract(class LadderQueryResult &query) = 0;
	virtual unsigned short extractlen(void) = 0;
	virtual short extractepos(void) = 0;
	virtual short extractipos(void) = 0;
	virtual void clear(void) = 0;
	virtual void resetextraction(void) = 0;
	virtual void resetinsertion(void) = 0;
	virtual void reset(void) = 0;
	virtual operator char *(void) = 0;
	virtual operator int(void) = 0;
	virtual operator +=(int size) = 0;
	virtual operator -=(int size) = 0;
};

union BotAccessFlags {
	struct {
		unsigned Read : 1;
		unsigned Write : 1;
		unsigned Admin : 1;
		unsigned Restricted : 1;
		unsigned Reserved : 28;
	};
	DWORD dwFlags;
};


struct BotNetUserInfo {
	DWORD dwServer, dwId;
	bool bCycle;
	char *pszName, *pszChannel;
	char szAccountName[16];
	BotAccessFlags AccessFlags;
	BotNetUserInfo(const char *_pszName, const char *_pszChannel) { pszName = newstr(_pszName); pszChannel = newstr(_pszChannel); }
	virtual ~BotNetUserInfo() { if(pszName) delete [] pszName; if(pszChannel) delete [] pszChannel; }
};

struct BotNetUserInfo2 : public BotNetUserInfo {
	char* pszDatabase;
	BotNetUserInfo2(const char *_pszName, const char *_pszChannel, const char *_pszDatabase) : BotNetUserInfo(_pszName, _pszChannel) { pszDatabase = newstr(_pszDatabase); }
	virtual ~BotNetUserInfo2() { if(pszDatabase) delete [] pszDatabase; }
};

struct BotNetUserInfoEx : public BotNetUserInfo { /* for Admin queries */
	DWORD dwIP, dwCycleUser;
	char *pszDatabase, *pszPreCycleChannel;
	BotNetUserInfoEx(const char *_pszName, const char *_pszChannel, const char *_pszDatabase, const char *_pszPreCycleChannel) : BotNetUserInfo(_pszName, _pszChannel) { pszDatabase = newstr(_pszDatabase); pszPreCycleChannel = newstr(_pszPreCycleChannel); }
	virtual ~BotNetUserInfoEx() { if(pszDatabase) delete [] pszDatabase; if(pszPreCycleChannel) delete [] pszPreCycleChannel; }
};

typedef BotNetUserInfo2 BotNetUserInfoCurrent;

struct PrivilegeMask {
	UserAttributes Attributes;
	char *pszMask;
	PrivilegeMask() { pszMask = 0; Attributes.dwFlags = 0; }
	PrivilegeMask(const char *_pszMask, UserAttributes _Attributes) { pszMask = newstr(_pszMask);  Attributes.Replace(_Attributes, true); }
	~PrivilegeMask() { if(pszMask) delete [] pszMask; }
	PrivilegeMask& operator=(const PrivilegeMask& other) { if(pszMask) delete [] pszMask; pszMask = newstr(other.pszMask); Attributes.dwFlags = other.Attributes.dwFlags; return *this; }
};

class BotNetConnectionState {
public:
	typedef DWORD (__cdecl MessageProcessorProc)(const char *pszMessage, const char *pszSender,
		ListEx <PrivilegeMask *>& Database, ListEx <BotNetUserInfo *>& BotNetUsers, void *Param);
	typedef DWORD (__cdecl DatabaseChangeProc)(DWORD dwFlags, PrivilegeMask *pUser,
		UserAttributes OriginalAttributes, ListEx <PrivilegeMask *>& Database,
		ListEx <BotNetUserInfo *>& BotNetUsers, void *Param);
	typedef void (__cdecl BotNetUserUpdateProc)(DWORD dwFlags, BotNetUserInfo *pUser,
		void *Param);
	typedef DWORD (__cdecl BotNetChatProc)(DWORD dwMessageType, DWORD dwMessageAction,
		const BotNetUserInfo *pSender, const char *pszMessage, void *Param);
	typedef DWORD (__cdecl AccountStatusProc)(DWORD dwEvent, BotNetUserInfo *pUser,
		const char *pszNewAccountName, void *Param);
	typedef DWORD (__cdecl AdminCommandProcessorProc)(DWORD dwEvent, BotNetUserInfoEx *pUser,
		DWORD dwBannedAddresses[128], void *Param);

	enum { // BotNet commands and BotNet chat
		Message_Database				=	0x00000000,
		Message_Broadcast				=	0x00000001,
		Message_Narrow					=	0x00000002 // Whisper for BotNet chat
	};
	enum { // BotNet chat actions
		Action_Talk						=	0x00000000,
		Action_Emote					=	0x00000001
	};
	enum {
		Dispatch_No_Error				=	0x00000000,
		Dispatch_SuccessfulConnect		=	0x00000001,
		Dispatch_FailedConnect			=	0x00000002,
		Dispatch_ReceiveError			=	0x00000004,
		Dispatch_Disconnected			=	0x00000008,
		Dispatch_Data					=	0x00000010,
		Dispatch_CycleStarting			=	0x00000020,
		Dispatch_MessageTooLarge		=	0x00000040,
		Dispatch_BadProtocolVersion		=	0x00000080,
		Dispatch_UnknownPacket			=	0x00000100,
		Dispatch_UnknownDatabaseCommand	=	0x00000200,
		Dispatch_UnknownChannel			=	0x00000400,
		Dispatch_InvalidUser			=	0x00000800,
		Dispatch_OldClientVersion		=	0x00001000,
		Dispatch_UnknownAccountStatus	=	0x00002000,
		Dispatch_UnknownAdminStatus		=	0x00004000,
		Dispatch_UnknownDatabaseStatus	=	0x00008000
	};
	enum {
		BotNet_Port						=	0x5555	/* 21845 */
	};
	enum {
		Current_Protocol_Version		=	0x01
	};
	enum {
		Database_Create_New_Entry,
		Database_Modify_Existing_Entry,
		Database_Delete_Existing_Entry,
		Database_Enumerated_Entry
	};
	enum {
		BotNetUsers_User_Join,
		BotNetUsers_User_Update,
		BotNetUsers_User_Leave,
		BotNetUsers_Enumerated_Entry
	};
	enum {
		AccountStatus_Logon_Failed,
		AccountStatus_Logon_Succeeded,
		AccountStatus_ChangePassword_Failed,
		AccountStatus_ChangePassword_Succeeded,
		AccountStatus_Create_Failed,
		AccountStatus_Create_Succeeded,
		AccountStatus_Name_Change
	};
	enum {
		Admin_Kick_Failed,
		Admin_Kick_Succeeded,
		Admin_Ban_Failed,
		Admin_Ban_Succeeded,
		Admin_Query_User_Failed,
		Admin_User_Information,
		Admin_Ban_List,
		Admin_Unban_Failed,
		Admin_Unban_Succeeded,
		Admin_Privileges_Enabled
	};
	enum {
		DBPassword_Read					=	0x00,
		DBPassword_Write				=	0x01,
		DBPassword_Restricted			=	0x02
	};
	enum {
		Account_Logon					=	0x00,
		Account_Change_Password			=	0x01,
		Account_Create_Account			=	0x02
	};
	enum {
		Server_Version_Basic			=	0x00000001,
		Server_Version_Enhanced			=	0x00000002,	/* Admin & Account support */
		Server_Version_DBInUserInfo		=	0x00000003, /* Database in userinfo */
		Server_Version_DBExtensions		=	0x00000004  /* Ability to toggle DB change negation server-side for
														changes made by users with insufficient	access */
	};
	enum {
		Account_Support					=	0x00000001,
		Admin_Support					=	0x00000002,
		DBEcho_Toggle					=	0x00000003,
		DBPrivilegeNotify				=	0x00000004,
		DBInUserInfo					=	0x00000005
	};
	enum {
		DB_Privilege_None				=	0x00000000,
		DB_Privilege_Readonly			=	0x00000001,
		DB_Privilege_Restricted			=	0x00000002,
		DB_Privilege_Write				=	0x00000004
	};

	BotNetConnectionState(HANDLE _hBotNetData/*, BotOutput *_Output, queuebuf *_packetqueue,
						  addqueueproc *_addqueue*/);
	~BotNetConnectionState();
	void Connect(void);
	void Disconnect(void);
	void NotifyBNCSDisconnect(void);
	void NotifyIdle(void);
	bool IsConnected(void) { return State >= CONNECTED; }
	bool IsDisconnected(void) { return State == DISCONNECTED; }
	bool IsLoggedOn(void) { return State == LOGGEDON; }
	bool IsConnecting(void) { return State == CONNECTING; }
	bool IsCyclingDone(void);
	bool HasAdminPrivileges(void) { return IsAdmin; }
	bool IsFeaturePresent(DWORD dwFeature);
	bool IsNegatingEntries(void) { return IsNegateEnabled; }
	bool CanWriteToDatabase(void) { return !!(GetDatabaseAccess() & DB_Privilege_Write); }
	time_t GetCycleEndTime(void) { return CycleEnd; }
	time_t GetNextIdleTime(void) { return NextIdleTime; }
	int GetBotNetUserCount(void) { return BotNetUsers.get_count(); }
	int GetPrivilegeMaskCount(void) { return Database.get_count(); }
	const char *GetPreCycleChannel(void) { if(pszPreCycleChannel) return pszPreCycleChannel; else return pszChannel; }
	DWORD GetConnectError(void) { return dwConnectError; }
	DWORD GetServerVersion(void) { return dwServerVersion; }
	DWORD GetSelfId(void) { return SelfId; }
	void FlushBotNetBuffers(bool bRemove);
	void UpdateName(const char *_pszUniqueName);
	void UpdateChannel(const char *_pszChannel);
	void UpdateServer(DWORD _dwBattleNetServer);
	void UpdatePassword(const char *_pszBotNetServerPassword);
	void UpdateDatabase(const char *_pszBotNetDatabase);
	void UpdateDatabasePassword(const char *_pszBotNetDatabasePassword);
	void UpdateBotNetServer(DWORD _dwBotNetServer);
	void UpdateStats(const char *_pszUniqueName, const char *_pszChannel, DWORD _dwBotNetServer,
		DWORD _dwBattleNetServer, const char *_pszBotNetServerPassword,
		const char *_pszBotNetDatabase,	const char *_pszBotNetDatabasePassword);
	void UpdateAccountInformation(const char *_pszAccountName, const char *_pszAccountPassword);
	void ChangeDatabasePassword(DWORD PassId, const char* NewDBPass);
	void SendBotNetMessage(const char *pszMessage, int Type = Message_Database, DWORD Id = 0);
	void SendBotNetChatMessage(const char *pszMessage, int Type = Message_Database, int Action = Action_Talk, DWORD Id = 0);
	void ChangeAccountPassword(const char *pszName, const char *pszOldPassword, const char *pszNewPassword);
	void ModifyDatabaseMask(const PrivilegeMask * lpMask) { SendDBModify(lpMask); }
	//void ModifyDatabaseMask(LPCSTR lpszMask, UserAttributes Attributes) { PrivilegeMask Temp(lpszMask, Attributes); SendDBModify(&Temp); }
	void DeleteDatabaseMask(const PrivilegeMask * lpMask) { SendDBDelete(lpMask); }
	//void DeleteDatabaseMask(LPCSTR lpszMask, UserAttributes Attributes) { PrivilegeMask Temp(lpszMask, Attributes); SendDBModify(&Temp); }
	void KickUser(DWORD dwUserId);
	void BanUser(DWORD dwUserId);
	void UnbanIP(DWORD dwBannedIPAddress);
	void QueryUser(DWORD dwUserId);
	void QueryBans(void);
	void SetNegateMode(bool bNegateUnderprivileged) { bPreferredNegateMode = bNegateUnderprivileged; }
	DWORD GetDatabaseAccess(void) { return dwDatabaseAccess; }

	MessageProcessorProc *SetMessageProcessorCallback(MessageProcessorProc *pNewCallback, void *Param) { MessageProcessorProc *pPrev = pMessageProcessor; pMessageProcessor = pNewCallback; MessageProcessorParam = Param; return pPrev; }
	DatabaseChangeProc *SetDatabaseChangeCallback(DatabaseChangeProc *pNewCallback, void *Param) { DatabaseChangeProc *pPrev = pDBProcessor; pDBProcessor = pNewCallback; DBProcessorParam = Param; return pPrev; }
	BotNetUserUpdateProc *SetBotNetUserChangeCallback(BotNetUserUpdateProc *pNewCallback, void *Param) { BotNetUserUpdateProc *pPrev = pBNUProcessor; pBNUProcessor = pNewCallback; BNUProcessorParam = Param; return pPrev; }
	BotNetChatProc *SetBotNetChatCallback(BotNetChatProc *pNewCallback, void *Param) { BotNetChatProc *pPrev = pBNCProcessor; pBNCProcessor = pNewCallback; BNCProcessorParam = Param; return pPrev; }
	AccountStatusProc *SetAccountStatusCallback(AccountStatusProc *pNewCallback, void *Param) { AccountStatusProc *pPrev = pAccountProcessor; pAccountProcessor = pNewCallback; AccountProcessorParam = Param; return pPrev; }
	AdminCommandProcessorProc *SetAdminProcessorCallback(AdminCommandProcessorProc *pNewCallback, void *Param) { AdminCommandProcessorProc *pPrev = pAdminProcessor; pAdminProcessor = pNewCallback; AdminProcessorParam = Param; return pPrev; }

	MessageProcessorProc *SetMessageProcessorCallback(MessageProcessorProc *pNewCallback, void *Param, void *&OldParam) { MessageProcessorProc *pPrev = pMessageProcessor; pMessageProcessor = pNewCallback; OldParam = MessageProcessorParam; MessageProcessorParam = Param; return pPrev; }
	DatabaseChangeProc *SetDatabaseChangeCallback(DatabaseChangeProc *pNewCallback, void *Param, void *&OldParam) { DatabaseChangeProc *pPrev = pDBProcessor; pDBProcessor = pNewCallback; OldParam = DBProcessorParam; DBProcessorParam = Param; return pPrev; }
	BotNetUserUpdateProc *SetBotNetUserChangeCallback(BotNetUserUpdateProc *pNewCallback, void *Param, void *&OldParam) { BotNetUserUpdateProc *pPrev = pBNUProcessor; pBNUProcessor = pNewCallback; OldParam = BNUProcessorParam; BNUProcessorParam = Param; return pPrev; }
	BotNetChatProc *SetBotNetChatCallback(BotNetChatProc *pNewCallback, void *Param, void *&OldParam) { BotNetChatProc *pPrev = pBNCProcessor; pBNCProcessor = pNewCallback; OldParam = BNCProcessorParam; BNCProcessorParam = Param; return pPrev; }
	AccountStatusProc *SetAccountStatusCallback(AccountStatusProc *pNewCallback, void *Param, void *&OldParam) { AccountStatusProc *pPrev = pAccountProcessor; pAccountProcessor = pNewCallback; OldParam = AccountProcessorParam; AccountProcessorParam = Param; return pPrev; }
	AdminCommandProcessorProc *SetAdminProcessorCallback(AdminCommandProcessorProc *pNewCallback, void *Param, void *&OldParam) { AdminCommandProcessorProc *pPrev = pAdminProcessor; pAdminProcessor = pNewCallback; OldParam = AccountProcessorParam; AdminProcessorParam = Param; return pPrev; }

	DWORD DispatchEvent(void);
	const char *GetPrivilegeMaskFlags(const PrivilegeMask *pMask);
	UserAttributes TranslateFlags(const char *pszFlags);
	PrivilegeMask *FindMask(const char *pszMask);
	BotNetUserInfo2 *FindBotNetUser(const char *pszName);
	BotNetUserInfo2 *FindBotNetUser(DWORD dwId);
	BotNetUserInfo2 *FindBotNetUserByAccount(const char *pzsAccount);
	void EnumBotNetUsers(void);
	void EnumPrivilegeMasks(void);

	static DWORD __cdecl DefaultMessageProcessor(const char *pszMessage, const char *pszSender,
		ListEx <PrivilegeMask *>& Database, ListEx <BotNetUserInfo *>& BotNetUsers, void *Param);
	static DWORD __cdecl DefaultDatabaseChangeProcessor(DWORD dwFlags, PrivilegeMask *pUser,
		UserAttributes OriginalAttributes, ListEx <PrivilegeMask *>& Database,
		ListEx <BotNetUserInfo *>& BotNetUsers, void *Param);
	static void __cdecl DefaultBotNetUserUpdateProcessor(DWORD dwFlags, BotNetUserInfo *pUser,
		void *Param);
	static DWORD __cdecl DefaultBotNetChatProcessor(DWORD dwMessageType, DWORD dwMessageAction,
		const BotNetUserInfo *pSender, const char *pszMessage, void *Param);
	static DWORD __cdecl DefaultAccountUpdateProcessor(DWORD dwEvent, BotNetUserInfo *pUser,
		const char *pszNewAccountName, void *Param);
	static DWORD __cdecl DefaultAdminCommandProcessor(DWORD dwEvent, BotNetUserInfoEx *pUser,
		DWORD dwBannedAddresses[128], void *Param); 
private:
	enum {
		DISCONNECTED,
		CONNECTING,
		CONNECTED,
		LOGGEDON
	};
	enum {
		Packet_Idle				=		0x00,
		Packet_Logon			=		0x01,
		Packet_StatsUpdate		=		0x02,
		Packet_Database			=		0x03,
		Packet_Message			=		0x04,
		Packet_Cycle			=		0x05,
		Packet_UserInfo			=		0x06,
		Packet_BroadcastMessage	=		0x07,
		Packet_NarrowMessage	=		0x08,
		Packet_ChangeDBPassword	=		0x09,
		Packet_BotNetVersion	=		0x0a,
		Packet_BotNetChat		=		0x0b,
		Packet_Admin			=		0x0c,
		Packet_Account			=		0x0d,
		Packet_DBExtensions		=		0x0e
	};
	enum {
		Packet_UserLoggingOff	=		0x07
	};
	enum {
		DBMessage_RequestDB		=		0x01,
		DBMessage_ModifyEntry	=		0x02,
		DBMessage_DeleteEntry	=		0x03
	};
	enum {
		Logon_Failed			=		0x00,
		Logon_Accepted			=		0x01
	};
	enum {
		Update_Failed			=		0x00,
		Update_Accepted			=		0x01
	};
	enum {
		Version_Current			=		0x01
	};
	enum {
		IdleInterval			=		120
	};
	enum {
		ChatMsg_Broadcast		=		0x00,
		ChatMsg_Database		=		0x01
	};
	enum {
		Admin_Kick_User			=		0x00,
		Admin_Ban_User			=		0x01,
		Admin_Query_User		=		0x02,
		Admin_Query_Bans		=		0x03,
		Admin_Unban_IP			=		0x04,
		Admin_Is_Privileged		=		0x05	/* Can use Admin commands */
	};
	enum {
		DB_Privilege_List		=		0x00,
		DB_Set_Negate_Mode		=		0x01
	};

	void SendLogon(void);
	void SendUsersRequest(void);
	void SendDatabaseRequest(void);
	void SendDBModify(const PrivilegeMask *pMask);
	void SendDBDelete(const PrivilegeMask *pMask);
	void SendStatsUpdate(void);
	void SendDBPasswordChange(DWORD PassId, const char* NewDBPass);
	void SendIdle(void);
	void SendAdminKickUser(DWORD dwUserId);
	void SendAdminBanUser(DWORD dwUserId);
	void SendAdminUnbanIP(DWORD dwIP);
	void SendAdminQueryUser(DWORD dwUserId);
	void SendAdminQueryBans(void);
	void SendAccountLogon(const char *pszName, const char *pszPassword);
	void SendAccountChangePassword(const char *pszName, const char *pszOldPassword,
		const char *pszNewPassword);
	void SendAccountCreate(const char *pszName, const char *pszPassword);
	void SendDBNegateMode(bool bNegateUnderprivileged);

	void SendPacket(unsigned char Id, VirtualBuffer& vData);

	void ClearCycle(void);
	void ClearDatabase(void);

	DWORD DispatchPacket(unsigned char Id, VirtualBuffer& PacketData);

	// Event handlers
	DWORD OnLogon(VirtualBuffer& PacketData);
	DWORD OnStatsUpdate(VirtualBuffer& PacketData);
	DWORD OnDatabaseCommand(VirtualBuffer& PacketData);
	DWORD OnMessage(VirtualBuffer& PacketData);
	DWORD OnCycle(VirtualBuffer& PacketData);
	DWORD OnUserInfo(VirtualBuffer& PacketData);
	DWORD OnUserLoggingOff(VirtualBuffer& PacketData);
	DWORD OnChangeDBPassword(VirtualBuffer& PacketData);
	DWORD OnBotNetVersion(VirtualBuffer& PacketData);
	DWORD OnBotNetChat(VirtualBuffer& PacketData);
	DWORD OnBotNetAdmin(VirtualBuffer& PacketData);
	DWORD OnBotNetAccountStatus(VirtualBuffer& PacketData);
	DWORD OnDatabaseExtension(VirtualBuffer& PacketData);

	SOCKET sBotNetSocket;
	SOCKADDR_IN BotNetServerAddress;
	HANDLE hBotNetData;
	SocketBuffers BotNetBuffers;
	char *pszBotNetServerPassword;
	char *pszBotNetDatabase, *pszBotNetDatabasePassword;
	char *pszUniqueName;
	char *pszChannel, *pszPreCycleChannel;
	char *pszAccountName, *pszAccountPassword;
	char Buffer[4096];
	int State;
	int BufferLength;
	time_t CycleEnd, NextIdleTime;
	bool IsAdmin;
	bool IsNegateEnabled;
	bool bPreferredNegateMode;
	DWORD SelfId;
	DWORD dwConnectError;
	DWORD dwBattleNetServer;
	DWORD dwServerVersion;
	DWORD dwDatabaseAccess;
	ListEx <BotNetUserInfo *> BotNetUsers;
	ListEx <PrivilegeMask *> Database;
//	BotOutput *Output;
//	addqueueproc *addqueue;
//	queuebuf *packetqueue;
	static const char *pszBotName;
	bool bFirstUserListingThisConnection;
	MessageProcessorProc *pMessageProcessor;
	DatabaseChangeProc *pDBProcessor;
	BotNetUserUpdateProc *pBNUProcessor;
	BotNetChatProc *pBNCProcessor;
	AccountStatusProc *pAccountProcessor;
	AdminCommandProcessorProc *pAdminProcessor;
	void *MessageProcessorParam, *DBProcessorParam, *BNUProcessorParam, *BNCProcessorParam;
	void *AccountProcessorParam, *AdminProcessorParam;
};


// End BotNetClient API

#endif